package kom.itbeankit.nw.ethernet;

import java.awt.*;

public class Signal extends java.awt.Label implements EthernetInterface
{

	public Signal()
	{
		//{{INIT_CONTROLS
		//}}
		super("LB",Label.CENTER);
		setBounds(0,0,16,12);
		setFont(new Font("Dialog", Font.BOLD, 12));
        turnOff();
		setSize(30,12);
	}
	
	//{{DECLARE_CONTROLS
	//}}
	//java.awt.Label label;
    
    
	public void setStatus(int status)
	{
		if (this.status!=status)
		{
            switch(status)
            {
                case SIGNAL_STATUS_OFF:
                    turnOff();
                    break;
                case SIGNAL_STATUS_ON:
                    turnOn();
                    break;
                case SIGNAL_STATUS_ALARM:
                    turnAlarm();
                    break;
                default:            
            }
		}
	}

	public int getStatus()
	{
		return status;
	}

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(300,300);
				this.add(new Signal());
			}
		}

		new DriverFrame().show();
	}

	public void turnOff(){
	    status = SIGNAL_STATUS_OFF;
	    setForeground(new Color(SIGNAL_COLOR_OFF));
	}
	public void turnOn(){
	    status = SIGNAL_STATUS_ON;
	    setForeground(new Color(SIGNAL_COLOR_ON));
	}
	public void turnAlarm(){
	    status = SIGNAL_STATUS_ALARM;
	    setForeground(new Color(SIGNAL_COLOR_ALARM));
	}

	protected int status;
}